import React, {Component} from 'react';
import PropTypes from 'prop-types';
import ReactTable from "react-table";
import Loading from "../../../../core/Loading";
import './InterventiList.css';
import {ButtonGroup, ButtonToolbar, Modal, ModalBody, ModalHeader} from "reactstrap";
import Ionicon from 'react-ionicons'
import {NavLink} from "react-router-dom";
import DeleteButton from "../../../../core/DeleteButton";
import moment from 'moment';
import 'moment/locale/it';
import AcquaticaDrop from "../../../../core/AcquaticaDrop";
import {NotificationManager} from 'react-notifications';
import InterventiFilters from "./components/InterventiFilters";

import Permissions from '../../../../permissions'


export default class InterventiList extends Component {

  constructor(props) {
    super(props);

    this.state = {
      filter: '',
      paginationLimit: 50,
      paginationOffset: 1,
      columns: [
        {
          Header: "ID",
          accessor: "id",
          filterable: false,
          sortable: false,
          width: 50,
        },
	   /*          {
          Header: "Validato",
          accessor: "validato",
          filterable: false,
          sortable: false,
          width:90,
          Cell: (row) => {
            return(
              <div>
                <span
                  style={{
                    color: !row.value ? '#ffbf00' : '#57d500',
                    transition: 'all .3s ease'
                  }}>
                  &#x25cf;
                </span>{' '}
                {row.value ? 'SI': "NO"}
              </div>
            );
          }
        },*/
        {
          Header: "Id intervento",
          accessor: "idScheda",
          filterable: false,
          sortable: false,
	  width:125,
        },
        {
          Header: "Specie",
          accessor: "specie",
          filterable: false,
          sortable: false,
	  width: 60,
	  Cell: (row) => { return (
		  <div style={{textAlign:'center'}}><img style={{width:'32px',height:'32px'}} src={'/LifeEremitaWeb/specie/'+row.value.id+'.png'} alt={row.value.denominazioneTaxon} title={row.value.denominazioneTaxon} /></div>
	  )
	  }
        },
        /*{
            Header: "Acquatica",
            accessor: "acquatica",
            width: 100,
            filterable: false,
            sortable: false,
            Cell: (row) => {
                return(<div className="text-center">
                    <AcquaticaDrop row={row}/>
                </div>);
            }
        },*/
        {
          Header: "Data inserimento",
          accessor: "inizioRilievo",
          filterable: false,
          sortable: false,
          width: 140,
          Cell: (row) => {
            return(<div>{moment(row.value).format("L")}</div>);
          }
        },
	{
          Header: "Tipologia",
          accessor: "tipo",
          filterable: false,
          sortable: false,
	  width:220,
          Cell: (row) => {
            return(<div>
		    {row.value=='habitat'?'Interventi su habitat':''}
		    {row.value=='prelievo'?'Prelievi/immissioni':''}
		    {row.value=='captive'?'Captive breeding':''}</div>);
          }
        },
        {
          Header: "Sito Natura 2000",
          accessor: "sitoNatura2000",
          filterable: false,
          sortable: false,
	  width:180,
          Cell: (row) => {
            return(<div>{row.value && row.value.id}</div>);
          }
        },

	{
          Header: "Compilatori",
          accessor: "rilevatori",
          filterable: false,
          sortable: false,
        },

	/*{
          Header: "Transetto",
          accessor: "transetto",
          filterable: false,
          sortable: false,
        },*/

        {
          Header: "",
          sortable: false,
          filterable: false,
          accessor: "id",
          Cell: (row) => this.renderCell(row),
        },
      ]
    };

    this.onFetchData = this.onFetchData.bind(this);
    this.onDeleteItem = this.onDeleteItem.bind(this);
    this.onFilterChange = this.onFilterChange.bind(this);
    this.getTotalPages = this.getTotalPages.bind(this);
  }

  componentWillMount() {
    moment.locale("it")
  }

  onDeleteItem(id) {
    this.props.mutate({ variables: {id: id} }).then(data => {
      this.props.data.refetch()
    }).catch(err => {
      NotificationManager.error("Errore durante l'eliminazione dell'intervento");
    })
  }

  onFetchData(state, instance) {
    this.props.data.refetch({
      pagination: {
        limit: state.pageSize,
        offset: state.page * state.pageSize,
      },
      filtro: this.state.filters,
      //sort: sortObj,
    })
    this.setState({
      paginationLimit: state.pageSize,
      paginationOffset: state.page * state.pageSize
    })
  }

  onFilterChange(filter) {
    this.setState({filter: filter})

    this.props.data.refetch({
      pagination: {
        limit: this.state.paginationLimit,
        offset: this.state.paginationOffset
      },
      filtro: filter,
      //sort: sortObj,
    })
  }

  getTotalPages () {
    if (this.props.data.countInterventi > 0) {
      return Math.ceil(this.props.data.countInterventi / this.state.paginationLimit)
    }

    return 0
  }

  renderCell (row) {
    const {
      utenteSessione,
      match
    } = this.props

    return (<div style={{display: 'flex', alignItems: 'center'}}>
        <div className="btn-group btn-group-sm" style={{margin: '0 auto'}}>
            <NavLink className="btn ionicon-btn btn-light" to={match.url + "/" + row.value}>
                <Ionicon icon="ios-search-outline" />
            </NavLink>
            {!utenteSessione.loading && (
            (!!row.original.utenteCreazione && (utenteSessione.utenteSessione.id == row.original.utenteCreazione.id) &&
                utenteSessione.utenteSessione.ruolo.permessi.filter(item => item.id == Permissions.writeOwnIntervento).length>0) ||
                utenteSessione.utenteSessione.ruolo.permessi.filter(item => item.id == Permissions.writeIntervento).length>0) &&
	    <div className="btn-group btn-group-sm" style={{display:'flex',margin:'0 auto'}}>
            	<NavLink className="btn ionicon-btn btn-light" to={match.url + "/" + row.value + "/edit"}>
                	<Ionicon icon="ios-create-outline"/>
            	</NavLink>
		<DeleteButton id={"delete-" + row.value} size={"sm"} onDelete={() => this.onDeleteItem(row.value)}>
                    <Ionicon icon="ios-trash-outline" color="#ffffff" />
                </DeleteButton>
	    </div>
            }
            
        </div>
    </div>)
  }

  render() {
    const {
      data,
      match,
      utenteSessione
    } = this.props

    const {
      columns,
      pages,
    } = this.state

    if(data.error) {
      return(<div className="text-danger">
        Errore nella ricezione dei dati
      </div>)
    }

    /*if(data.loading) {
        return <Loading/>;
    }*/

    return(
      <div className="container-fluid">
        <div className="btn-toolbar" style={{backgroundColor: '#fff'}}>
          <div className="btn-group mr-2 ml-auto">
            {!utenteSessione.loading &&
            utenteSessione.utenteSessione.ruolo.permessi.filter(item => item.id == Permissions.insertIntervento).length>0 &&
              <NavLink className="btn ionicon-btn btn-light" to={match.url + "/create"}>
                  <Ionicon icon="ios-add" style={{marginRight: '5px', marginLeft: '-8px'}}/>
                  Nuova Scheda
              </NavLink>
            }
            {false &&
            <button className="btn ionicon-btn btn-light" onClick={() => window.open('/LifeEremitaWeb/csv/interventi/'+(this.state.filter || '*')+'/intervento.csv')} type="button">
              <Ionicon icon="ios-exit-outline" style={{marginRight: '5px', marginLeft: '-8px'}} />
              Esporta CSV
            </button>
            }
          </div>
        </div>

        <InterventiFilters
          onFilterChange={this.onFilterChange} />

        <ReactTable
          manual
          filterable
          loading={data.loading}
          noDataText={"Nessun intervento presente"}
          onFetchData={this.onFetchData}
          pages={this.getTotalPages()}
          className="-highlight"
          data={data.interventi}
          style={{}}

          defaultPageSize={10}
          nextText="Avanti"
          previousText="Indietro"
          loadingText="Caricamento in corso..."
          rowsText="elementi"
          ofText="di"
          pageText="Pagina"
          columns={columns} />
      </div>
    )
  }
}

InterventiList.defaultProps = {}

InterventiList.propTypes = {

}
